# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import request_valid, get_hr_min, user_photo, stamp2datetime, datetime2stamp, \
    interface_response, online_employee, SUCCESS_CODE, this_week_period
import json


class BioTimeAppProfile(object):

    """
    【Profile】个人信息
    """

    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def profile(self, source, device_token, language, token):
        """
        获取人员信息
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
        """
        emp = online_employee()
        department = emp.DeptID and emp.DeptID.name or ''
        position = emp.position and emp.position.name or ''
        photo_url = user_photo(emp.PIN)
        profile = {
            'pin': emp.PIN,
            'name': emp.EName,
            'photo': photo_url,
            'department': department,
            'position': position,
            'area': emp.get_attarea(),
        }
        print "[*]Profile:", profile
        return interface_response(SUCCESS_CODE, json.dumps(profile), '', 'successful')

    @request_valid
    @ladonize(long, int, str, str, str, rtype=str)
    def work_time(self, current_day, source, device_token, language, token):
        """
        获取工作时间
        @param current_day:     当前天
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:
        返回数据格式 ["items":[{"date": "", "work_time": "05:00", "remaining_time": "03:00", "overtime": "00:00"}]]
        """
        from mysite.sql_utils import get_sql, p_query
        import datetime
        stamp_current = current_day
        current_day = stamp2datetime(current_day)
        start, end = this_week_period(current_day)
        emp = online_employee()
        params = {'userid': emp.pk, 'start': start.strftime('%Y-%m-%d'), 'end': end.strftime('%Y-%m-%d')}
        sql = get_sql('sql', sqlid='get_work_time', app="pywebsv", params=params)
        rows = p_query(sql)
        vals = {}
        print "[*]Rows:", rows
        total_work_time = 0
        if rows:
            for r in rows:
                key = r[0].strftime('%Y%m%d')
                total_work_time += r[1]
                vals[key] = {
                    'date': datetime2stamp(r[0]),
                    'work_time': get_hr_min(r[1]),
                    'remaining_time': get_hr_min(r[2]),
                    'overtime': get_hr_min(r[3]),
                }
        items = []
        loop_start = start
        while loop_start <= current_day:
            key = loop_start.strftime('%Y%m%d')
            item = vals.get(key, {
                'date': datetime2stamp(loop_start),
                'work_time': '00:00',
                'remaining_time': '00:00',
                'overtime': '00:00',
            })
            items.append(item)
            loop_start += datetime.timedelta(days=1)
        data = {
            'current_day': stamp_current,
            'total_work_time': '{0}:{1}'.format(*map(int, get_hr_min(total_work_time).split(':'))),
            'items': items
        }
        return interface_response(SUCCESS_CODE, json.dumps(data), '', 'successful')